ORCA/M Asm65816 2.1.0

0001 2684                       title 'TaskMaster' 
0002 2684              **********************************************************************
0003 2684              *
0004 2684              * TaskMaster (All by itself)
0005 2684              *
0006 2684              * Copyright Apple Computer, Inc. 1986-89
0007 2684              * All rights reserved
0008 2684              * Original Code written by Dan Oliver
0009 2684              * 
0010 2684              **********************************************************************
0011 2684
0012 2684              **********************************************************************
0013 2684              *
0014 2684              * CHANGE HISTORY
0015 2684              *
0016 2684              * 22 June 88        Harry Yee
0017 2684              *                   Converted to MAX development system. 
0018 2684              *
0019 2684              * 20 Sep 88         Steven Glass
0020 2684              *
0021 2684              * Added features to task master so that it will find and track control
0022 2684              * and handle keystrokes.
0023 2684              *
0024 2684              * 04 Oct 88         Steven Glass
0025 2684              *
0026 2684              * Got TaskMasterDA working.
0027 2684              *
0028 2684              * 06 Oct 88         Steven Glass
0029 2684              *
0030 2684              * There are a number of places where the event record pointer can get 
0031 2684              * trashed.  I've tried to identify them all and restore it after 
0032 2684              * this occurs.
0033 2684              *
0034 2684              * 20 Oct 88         Dan O.
0035 2684              *
0036 2684              * Implemented TaskMaster multi-click.  Task record had to be extended.
0037 2684              * Made CompileString a tool call.
0038 2684              *
0039 2684              * 22 Nov 88         Steven Glass
0040 2684              *
0041 2684              * Minor change to TaskMaster to preserve register around call to 
0042 2684              * ckDoubleClick.
0043 2684              *
0044 2684              * 01 Dec 88         Steven Glass
0045 2684              *
0046 2684              * Changed the way CkActiveate works so that the controls are
0047 2684              * not drawn, but rather their rects are made invalid.
0048 2684              *
0049 2684              * Changed TaskMasterKey to see if there is a top window before 
0050 2684              * sending events to it.
0051 2684              *
0052 2684              * 22 Jan 89         Steven Glass
0053 2684              *
0054 2684              * Changed routine that passed idle events on to controls.  We had
0055 2684              * a problem that we were passing too many events including events
0056 2684              * that were only idle because the DeskManager handled them.  We
0057 2684              * now only pass them if the event manager says no event and the
0058 2684              * event code is zero.
0059 2684              *
0060 2684              *
0061 2684              * 15 Feb 89         Dave Good
0062 2684              *
0063 2684              * Added code to pass menu item events to the active control. I added a
0064 2684              * new taskmaster code (wInControlMenu) which is returned as an action only
0065 2684              * to inform the application that the control already accepted the menu
0066 2684              * item. The way that menu events are passed to controls is a little funny;
0067 2684              * I replace the event.what field of the task record with wInSpecial or wInMenuBar
0068 2684              * depending on which item numbers are being passed. The menu item ID is passed
0069 2684              * in TaskData, just as it would be returned to the application. If the control
0070 2684              * returns non zero, I return a null task code to the application since the
0071 2684              * control took the menu event. If the control returns zero, I pass the menu event
0072 2684              * back to the application.
0073 2684              *
0074 2684              * 19 Feb 89         Steven Glass
0075 2684              *
0076 2684              * Made InvertIfNecessary into a subroutine and called it from
0077 2684              * inside TaskMasterContent and TaskMasterKey.
0078 2684              *
0079 2684              * Changed way SendEventToCtl is called to save code (in TaskMaster).
0080 2684              *
0081 2684              * 20 Feb 89         Steven Glass
0082 2684              *
0083 2684              * Removed non-TaskMaster calls (now in file NewCalls.asm).
0084 2684              * Made TaskMaster stack-based so it would be re-entrant.
0085 2684              *
0086 2684              * 23 Feb 89         Steven Glass
0087 2684              *
0088 2684              * Fixed bug in update routine.  StartDrawing is now called before
0089 2684              * user routine is called.  ZeroOrigin is called after.
0090 2684              *
0091 2684              * 13 Mar 89
0092 2684              *
0093 2684              * Fixed bug in TaskMasterKey (BRC #45532, 45533). Origin was not being 
0094 2684              * set up correctly when control was being selected. 
0095 2684              *
0096 2684              * 3/15/89           Mensch
0097 2684              * Fixed brc #45932. Now return window ptr in task data when a control
0098 2684              * key equiv is being used.
0099 2684              *
0100 2684              * 28 Mar 89         Steven Glass
0101 2684              *
0102 2684              * Changed ck_activate to call futzCtls rather than invalctls.  This
0103 2684              * lets controls that are not going to do total redraws to optimize
0104 2684              * their handling of activation.
0105 2684              *
0106 2684              * 30 Mar 89         Steven Glass
0107 2684              *
0108 2684              * Saved port around handling idle events in TaskMaster.
0109 2684              *
0110 2684              * 31 Mar 89         Steven Glass
0111 2684              *
0112 2684              * Pulled yesterday's change and made a global change to save
0113 2684              * and restore grafPort.
0114 2684              *
0115 2684              * 31 Mar 89         Steven Glass
0116 2684              *
0117 2684              * Pushed right value for TaskMasterDA case.
0118 2684              *
0119 2684              * 09 Apr 89         Steven Glass
0120 2684              *
0121 2684              * Found that busyflag was always set when going into CDAs if
0122 2684              * TaskMaster was being used.  Problem was that TaskMaster incremented
0123 2684              * the busy flag before calling GetNextEvent (where CDA menu was
0124 2684              * displayed).  So we moved the call.
0125 2684              *
0126 2684              * Also took out a little redundant code that was found in the 
0127 2684              * code review we had last Tuesday.
0128 2684              *
0129 2684              * 13 Apr 89         Steven Glass
0130 2684              *
0131 2684              * Save DBR and D-page in global data area so it can be used by
0132 2684              * w-def proc.
0133 2684              *
0134 2684              * 19 Apr 89         Steven Glass
0135 2684              *
0136 2684              * Change to code that tracks controls.  Treats scroll bars
0137 2684              * specially.
0138 2684              *
0139 2684              * Change to code that calls Task_menu2 in TaskMasterKey so 
0140 2684              * that handled events are returned correctly.
0141 2684              *
0142 2684              * 8/24/89           Mensch
0143 2684              *
0144 2684              * Implement the tmNoGetNextEvent bit in taskmask. When this bit is set
0145 2684              * TaskMaster does not call SystemTask or GetNextEvent, the event record
0146 2684              * MUST be already filled in by the application.
0147 2684              * 
0148 2684              **********************************************************************
0149 2684
0150 2684
0151 2684                       blanks off 
0152 2684
0153 2684                       print Push 
0154 2684                       print off 
0155 2684                       include 'all.macros' 
0156 2684                       include 'WindMgrEquates.asm' 
0157 2684                       include ':::ControlMgr:CtlCustomEqus.asm' 
0158 2684
0159 2684                       print pop 
0160 2684
0161 2684              **********************************************************************
0162 2684              *
0163 2684              * Equates for direct page during execution of task master
0164 2684              *
0165 2684              **********************************************************************
0166 2684
0167 2684                             DefineStack  
0168 2684              WindMgrD       word  
0169 2684              ThisAction     word  
0170 2684              TheTaskMask    LONG  
0171 2684              WindPtr        LONG  
0172 2684              DataPtr        LONG  
0173 2684              CallingFlag    WORD  
0174 2684              OrigB          BYTE  
0175 2684              OrigD          word  
0176 2684              RTL1           block 3  
0177 2684              RTL2           block 3  
0178 2684              InputTaskRecPtr LONG  
0179 2684              InputEventMask WORD  
0180 2684              OutputTaskCode WORD  
0181 2684
0182 2684
0183 2684                       title 'TaskMaster' 
0184 2684              ****************************************************************
0185 2684              *
0186 2684              TaskMaster PROC EXPORT 
0187 2684              *
0188 2684              * App's little helper
0189 2684              *
0190 2684              *
0191 2684              *   IN:    PUSH:WORD - space for result code
0192 2684              *          PUSH:WORD - event mask used when calling GetNextEvent.
0193 2684              *          PUSH:LONG - pointer to Task record.
0194 2684              *
0195 2684              *  OUT:    WORD - Same as Event Code with a few changes:
0196 2684              *
0197 2684              * External Refs:
0198 2684                       IMPORT ckDoubleClick 
0199 2684                       import ePop6Bytes 
0200 2684                       import Task_Menu 
0201 2684                       import MakeGPIntoWP 
0202 2684                       import Do_Update2 
0203 2684                       import CkActivate 
0204 2684                       import BreakOut 
0205 2684                       import PushFrontWindow 
0206 2684                       import CallProc2 
0207 2684              *
0208 2684              * Entry Points:
0209 2684                       ENTRY DAEntry 
0210 2684              *
0211 2684                       longa on                       ; mode
0212 2684                       longi on
0213 2684              *
0214 2684              *
0215 2684              * Change History
0216 2684              *
0217 2684              * 22 Nov 88         Steven Glass
0218 2684              *
0219 2684              * Saved task code around call to check double click.
0220 2684              *
0221 2684              * 22 Jan 89         Steven Glass
0222 2684              *
0223 2684              * Changed routine that passed idle events on to controls.  We had
0224 2684              * a problem that we were passing too many events including events
0225 2684              * that were only idle because the DeskManager handled them.  We
0226 2684              * now only pass them if the event manager says no event and the
0227 2684              * event code is zero.
0228 2684              *
0229 2684              * 19 feb 89         Steven Glass
0230 2684              *
0231 2684              * Changed way SendEvtToCtl was called to save code.
0232 2684              *
0233 2684              * 20 Feb 89         Steven Glass
0234 2684              *
0235 2684              * Started conversion to Stack Based code
0236 2684              *
0237 2684              * 30 Mar 89         Steven Glass
0238 2684              *
0239 2684              * TaskMaster now preserves the grafPort even when the idle 
0240 2684              * event is sent to the target control.
0241 2684              *
0242 2684              * 31 Mar 89         Steven Glass
0243 2684              *
0244 2684              * TaskMaster saves the port on entry and restores it on exit.
0245 2684              *
0246 2684              * Change above is removed as being redundant.
0247 2684              *
0248 2684              * 31 Mar 89         Steven Glass
0249 2684              *
0250 2684              * Pushed right value for TaskMasterDA case.
0251 2684              * 
0252 2684              * 13 Apr 89         Steven Glass
0253 2684              *
0254 2684              * Save DBR and D-page in global data area for w-def proc.
0255 2684              *
0256 2684              * 8/25/89           Mensch
0257 2684              *
0258 2684              * Add tmNoGetNextEvent bit.
0259 2684              * Add tmModalWindow bit.
0260 2684              *
0261 2684              ****************************************************************
0262 2684
0263 2684
0264 2684 0B                    phd                            Save d-page and dbr on stack
0265 2685 8B                    phb   
0266 2686 5B                    tcd                            Switch in wmgr's dPage for a momment
0267 2687
0268 2687 F4 00 00              pea   $0000                    Push CallingFlag of zero to indicate call origin
0269 268A
0270 268A              DAEntry   
0271 268A
0272 268A
0273 268A D4 DA                 pei   <Data+2                  Push pointer to window mgr's globals
0274 268C D4 D8                 pei   <Data
0275 268E
0276 268E 48                    pha                            Push space for Window Pointer
0277 268F 48                    pha   
0278 2690
0279 2690 48                    pha                            Push space for the task mask
0280 2691 48                    pha   
0281 2692
0282 2692 F4 00 00              pea   $0000                    ThisAction starts as zero
0283 2695
0284 2695 0B                    phd                            Push window manager's direct page!
0285 2696
0286 2696 3B                    tsc                            Turn our stack into direct page
0287 2697 5B                    tcd   
0288 2698
0289 2698
0290 2698 48                    pha                            Save the Port on the stack
0291 2699 48                    pha   
0292 269A A2 04 1C 22           _GetPort 
0293 26A1
0294 26A1 24 11                 bit   CallingFlag
0295 26A3 10 04                 bpl   DoNormalStuff
0296 26A5 D4 11                 pei   CallingFlag              ; push a non-zero value so it looks like there was an event.
0297 26A7 80 15                 bra   SkipNormalStuff
0298 26A9              DoNormalStuff  
0299 26A9              ;
0300 26A9              ; Call System Task now and get it over with
0301 26A9              ;
0302 26A9              ; 8/24/89 Mensch
0303 26A9              ; Added code here to skip getNextEvent in the case where the tmNoGetNextEvent bit is set in the
0304 26A9              ; task mask.
0305 26A9
0306 26A9                       ldy   #taskMask+2              ; get high word of the task mask
0307 26A9                       lda   [InputTaskRecPtr],y
0308 26A9                       and   #tmNoGetNextEvent
0309 26A9                       beq   @getEvent                ; if zero, get an event here
0310 26A9              ; If we get this far, then no call to get next event should be made,
0311 26A9              ; what we will do instead is get the taskwhat field and push it on the stack as the result of 
0312 26A9              ; getnextevent, so that we can proceed
0313 26A9                       lda   [InputTaskRecPtr]        ; event what is first field
0314 26A9                       pha   
0315 26A9                       bra   SkipNormalStuff            ; and continue with the rest of the call...
0316 26A9
0317 26A9              @getEvent  
0318 26A9              ;
0319 26A9 A2 05 19 22           _SystemTask                    Call Desk Manager so it can pass a tick.
0320 26B0
0321 26B0
0322 26B0 48                    pha   
0323 26B1 D4 20                 pei   InputEventMask
0324 26B3 D4 1E                 pei   InputTaskRecPtr+2
0325 26B5 D4 1C                 pei   InputTaskRecPtr
0326 26B7 A2 06 0A 22           _GetNextEvent 
0327 26BE
0328 26BE              SkipNormalStuff  
0329 26BE 22 64 00 E1           jsl   IncBusyFlg               Inc flag so that shared resources are in danger
0330 26C2
0331 26C2              ;
0332 26C2              ; Put d-page and dbr in global data for use by w-def Procs.
0333 26C2              ; 13 Apr 89 SEG
0334 26C2 A0 34 00              ldy   #callerDPage
0335 26C5 A5 14                 lda   OrigD
0336 26C7 97 0D                 sta   [<dataPtr],y
0337 26C9 A0 36 00              ldy   #callerDataB             high byte must be valid
0338 26CC A5 12                 lda   OrigB-1
0339 26CE 97 0D                 sta   [<DataPtr],y
0340 26D0              ; End Change
0341 26D0
0342 26D0 A7 1C                 lda   [<InputTaskRecPtr]       Check this so we don't zero important data
0343 26D2 C9 13 00              cmp   #wInContent              for TaskMasterDA case
0344 26D5 F0 14                 beq   SkipThisShit
0345 26D7
0346 26D7 A0 02 00              ldy   #message                 Clone message into TaskData just in case.
0347 26DA B7 1C                 lda   [<InputTaskRecPtr],y
0348 26DC AA                    tax   
0349 26DD C8                    iny   
0350 26DE C8                    iny   
0351 26DF B7 1C                 lda   [<InputTaskRecPtr],y
0352 26E1 A0 12 00              ldy   #TaskData+2
0353 26E4 97 1C                 sta   [<InputTaskRecPtr],y
0354 26E6 88                    dey   
0355 26E7 88                    dey   
0356 26E8 8A                    txa   
0357 26E9 97 1C                 sta   [<InputTaskRecPtr],y
0358 26EB
0359 26EB              SkipThisShit  
0360 26EB A0 16 00              ldy   #TaskMask+2              Get TaskMask into a zero page location.
0361 26EE B7 1C                 lda   [<InputTaskRecPtr],y
0362 26F0 85 07                 sta   TheTaskMask+2
0363 26F2 29 E0 FF              and   #$FF80                   Bits 23-31 must be clear.
0364 26F5 F0 09                 beq   mask_ok
0365 26F7
0366 26F7 68                    pla                            Get rid of return flag from GetNextEvent.
0367 26F8 64 22                 stz   OutputTaskCode           Return event state.
0368 26FA A0 03 0E              ldy   #TaskMaskErr             Bits 21-31 not clear in TaskMask err.
0369 26FD 82 96 01              brl   UnlinkWithError
0370 2700
0371 2700 88           mask_ok  dey   
0372 2701 88                    dey   
0373 2702 B7 1C                 lda   [<InputTaskRecPtr],y
0374 2704 85 05                 sta   <TheTaskMask
0375 2706 68                    pla                            Get returned flag from GetNextEvent.
0376 2707 D0 4F                 bne   do_event
0377 2709
0378 2709
0379 2709              ;-----------------------------------------------------------
0380 2709              ;
0381 2709              ; If we get here, then the event was null or taken by the 
0382 2709              ; desk manager.  If it was really null, see if we 
0383 2709              ; should send it on to the active control
0384 2709              ;
0385 2709 A7 1C                 lda   [<InputTaskRecPtr]
0386 270B D0 42                 bne   NotNull
0387 270D
0388 270D A5 07                 lda   TheTaskMask+2
0389 270F 29 10 00              and   #tmIdleEvents
0390 2712 F0 3B                 beq   NotNull
0391 2714
0392 2714
0393 2714 48                    pha                            ; is there a window?
0394 2715 48                    pha   
0395 2716 A2 0E 15 22           _FrontWindow 
0396 271D A3 03                 lda   3,s
0397 271F 03 01                 ora   1,s
0398 2721 D0 04                 bne   ThereIsAWindow
0399 2723
0400 2723 68           NoWindow pla                            ; no window, clean the stack
0401 2724 68                    pla   
0402 2725 80 28                 bra   NotNull
0403 2727
0404 2727              ThereIsAWindow  
0405 2727 A2 0E 4D 22           _StartDrawing                  ; start drawing in front window so can send idle
0406 272E
0407 272E 48                    pha                            ; space for result
0408 272F F4 FF FF              PushWord #True                 ; Send only to active control
0409 2732 A9 00 00              lda   #0                       ; zero means front window
0410 2735 48                    pha   
0411 2736 48                    pha   
0412 2737 D4 1E                 pei   InputTaskRecPtr+2
0413 2739 D4 1C                 pei   InputTaskRecPtr
0414 273B A2 10 29 22           _SendEventToCtl 
0415 2742 68                    pla                            ; ignore result
0416 2743
0417 2743 A9 00 00              lda   #0                       ; reset origin
0418 2746 48                    pha   
0419 2747 48                    pha   
0420 2748 A2 04 23 22           _SetOrigin 
0421 274F
0422 274F
0423 274F              NotNull   
0424 274F              ;-----------------------------------------------------------
0425 274F
0426 274F
0427 274F A2 00 00              ldx   #inNull                  No event to act on if MenuSelect off.
0428 2752 20 39 2B              jsr   task_menu
0429 2755 82 2F 01              brl   GoHome                   Return event flag.
0430 2758              ;
0431 2758              ;
0432 2758              ; --- Event happened, handle it ----------------------------
0433 2758              ;
0434 2758              ; --- Is this an event the Task Master should handle? ------
0435 2758              ;
0436 2758 A7 1C        do_event lda   [<InputTaskRecPtr]       Event code.
0437 275A C9 01 00              cmp   #inButtDwn               Button down event?
0438 275D F0 4F                 beq   ck_butt
0439 275F C9 03 00              cmp   #inKey                   Key event?
0440 2762 F0 37                 beq   ck_key
0441 2764 C9 05 00              cmp   #inAutoKey               Auto key?
0442 2767 F0 32                 beq   ck_key
0443 2769 C9 08 00              cmp   #inActWind               Activate/Inactivate event?
0444 276C F0 25                 beq   ck_act
0445 276E C9 06 00              cmp   #inUpdate                Update event?
0446 2771 F0 04                 beq   ck_update
0447 2773
0448 2773              ; not an event we will handle.
0449 2773 AA                    tax                            put code in x-reg
0450 2774 82 10 01              brl   GoHome                   and clear out.
0451 2777
0452 2777
0453 2777              ck_update  
0454 2777 AA                    tax                            Save inUpdate.
0455 2778 A5 05                 lda   <TheTaskMask             Ok to handle update event?
0456 277A 29 02 00              and   #TM_UPDATE
0457 277D D0 03                 bne   ok31
0458 277F 82 05 01              brl   GoHome                   Update feature is masked off.
0459 2782              ;
0460 2782 20 74 2C     ok31     jsr   MakeGPIntoWP             turn TaskData into a pointer to wind record
0461 2785              ;
0462 2785 20 E0 2A              jsr   do_update2               Have application draw update region.
0463 2788              ;
0464 2788 AA                    tax                            Was update handled?
0465 2789 D0 05                 bne   skip3
0466 278B A9 06 00              lda   #inUpdate                Tell caller that update was performed.
0467 278E 85 03                 sta   <ThisAction
0468 2790              ;
0469 2790 82 F4 00     skip3    brl   GoHome
0470 2793              ;
0471 2793              ;
0472 2793              ;
0473 2793              ; --- Never fear, Task Master will handle the event. ------------------------
0474 2793              ;
0475 2793              ; ------- Check to redraw controls for activate/inactivate events -----------
0476 2793              ;
0477 2793              ; Always return the inActWind event code in case application wants to 
0478 2793              ; do more with the event.
0479 2793              ; 
0480 2793 48           ck_act   pha                            Save event code.
0481 2794 20 48 2C              jsr   ckactivate               Redraw window's controls.
0482 2797 FA                    plx                            Get inActWind event code.
0483 2798 82 EC 00              brl   GoHome                   Return event code to user.
0484 279B              ;
0485 279B              ;
0486 279B              ; ------- Call routine to handle keys ------------------
0487 279B              ;
0488 279B              ck_key    
0489 279B 48                    pha   
0490 279C 48                    pha   
0491 279D D4 1E                 pei   <InputTaskRecPtr+2
0492 279F D4 1C                 pei   <InputTaskRecPtr
0493 27A1 20 33 2C              jsr   PushFrontWindow
0494 27A4 A2 0E 5E 22           _TaskMasterKey 
0495 27AB
0496 27AB 82 D4 00              brl   JoinTMContent
0497 27AE
0498 27AE              ;
0499 27AE              ;
0500 27AE              ; ------- Handle button down event -------------------------------
0501 27AE              ;
0502 27AE              ck_butt   
0503 27AE 48                    pha                            Save the event code
0504 27AF
0505 27AF A5 1C                 lda   <InputTaskRecPtr         Pass pointer to task record.
0506 27B1 A6 1E                 ldx   <InputTaskRecPtr+2
0507 27B3 20 E3 2C              jsr   ckDoubleClick            Set double-click fields.
0508 27B6
0509 27B6 FA                    plx                            Get event code off stack
0510 27B7
0511 27B7 A5 05                 lda   <TheTaskMask             Ok to handle button down event?
0512 27B9 29 04 00              and   #TM_FINDW
0513 27BC D0 03                 bne   ok32
0514 27BE 82 C6 00              brl   GoHome                   Button handler is masked off.
0515 27C1
0516 27C1              ;
0517 27C1              ; Call FindWindow
0518 27C1              ;
0519 27C1 48           ok32     pha                            Return space.
0520 27C2 A6 1E                 ldx   <InputTaskRecPtr+2       Return window pointer in TaskData.
0521 27C4 A5 1C                 lda   <InputTaskRecPtr
0522 27C6 18                    clc   
0523 27C7 69 10 00              adc   #TaskData
0524 27CA 90 01                 bcc   store1
0525 27CC E8                    inx   
0526 27CD DA           store1   phx   
0527 27CE 48                    pha   
0528 27CF A0 0C 00              ldy   #where+2                 Pass point where button down.
0529 27D2 B7 1C                 lda   [<InputTaskRecPtr],y
0530 27D4 48                    pha   
0531 27D5 88                    dey   
0532 27D6 88                    dey   
0533 27D7 B7 1C                 lda   [<InputTaskRecPtr],y
0534 27D9 48                    pha                            Find if down on window.
0535 27DA A2 0E 17 22           _FindWindow 
0536 27E1 FA                    plx                            Get returned value.
0537 27E2
0538 27E2              ;
0539 27E2              ; ------- Handle system menu bar interaction ----------------------
0540 27E2              ;
0541 27E2 E0 11 00              cpx   #wInMenuBar
0542 27E5 D0 08                 bne   next5
0543 27E7              ;
0544 27E7 86 03                 stx   <ThisAction              Assume this will be the action (its changed if it is different)
0545 27E9
0546 27E9 20 39 2B              jsr   task_menu                Handle system menu bar.
0547 27EC 82 98 00              brl   GoHome                   x = return code.
0548 27EF              ;
0549 27EF              ;
0550 27EF              ; --- Do some common setups --------------------------------------
0551 27EF              ;
0552 27EF 20 D2 2A     next5    jsr   breakout                 Break out parameters from event rec.
0553 27F2
0554 27F2 24 11                 bit   CallingFlag
0555 27F4 10 06                 bpl   @CheckForSystem
0556 27F6
0557 27F6 8A                    txa   
0558 27F7 29 FF 7F              and   #$7FFF
0559 27FA 80 27                 bra   ok6
0560 27FC
0561 27FC              @CheckForSystem  
0562 27FC 8A                    txa                            Get value returned from FindWindow.
0563 27FD 10 24                 bpl   ok6                      System window?
0564 27FF              ;
0565 27FF              ;
0566 27FF              ; --- Handle system window ---------------------------------------
0567 27FF              ;
0568 27FF A5 05                 lda   <TheTaskMask             Ok to handle system window event?
0569 2801 29 20 00              and   #TM_SYSCLK
0570 2804 D0 03                 bne   ok35
0571 2806 82 7E 00              brl   GoHome                   System window feature is masked off.
0572 2809              ;
0573 2809 D4 1E        ok35     pei   <InputTaskRecPtr+2       Pass pointer to event record.
0574 280B D4 1C                 pei   <InputTaskRecPtr
0575 280D D4 0B                 pei   <WindPtr+2               Pass pointer to window's port.
0576 280F D4 09                 pei   <WindPtr
0577 2811 DA                    phx                            Pass result from FindWindow.
0578 2812 A2 05 17 22           _SystemClick 
0579 2819              ;
0580 2819 A9 12 00              lda   #wClickCalled            SystemClick called.
0581 281C 85 03                 sta   <ThisAction
0582 281E              ;
0583 281E A2 00 00     null_out ldx   #0
0584 2821 80 64                 bra   GoHome
0585 2823              ;
0586 2823              ;
0587 2823              ; --- Handle the specific task -----------------------------------
0588 2823              ;
0589 2823 A0 C0 01     ok6      ldy   #taskRequest             Save task code.
0590 2826 97 0D                 sta   [<DataPtr],y
0591 2828 A6 01                 ldx   WindMgrD
0592 282A 9F DE 00 00           sta   >work,x                  Pass result from FindWindow to callProc2.
0593 282E              ;
0594 282E 38                    sec   
0595 282F E9 13 00              sbc   #$0013
0596 2832 B0 03                 bcs   ok8
0597 2834 A9 06 00              lda   #6                       Can't handle if because out of range.
0598 2837 0A           ok8      asl   a
0599 2838 AA                    tax   
0600 2839 BF AD 28 FD           lda   >masks,x
0601 283D F0 06                 beq   dontHandle
0602 283F 10 0B                 bpl   ok10
0603 2841 25 05                 and   <TheTaskMask
0604 2843 F0 0B                 beq   ok9
0605 2845              ;
0606 2845 A0 C0 01     dontHandle ldy   #taskRequest           Get task code.
0607 2848 B7 0D                 lda   [<DataPtr],y
0608 284A 80 24                 bra   ckControls
0609 284C              ;
0610 284C 25 05        ok10     and   <TheTaskMask
0611 284E F0 F5                 beq   dontHandle
0612 2850              ;
0613 2850              ok9       
0614 2850
0615 2850
0616 2850 20 74 2C              jsr   MakeGPIntoWP             turn TaskData into a pointer to wind record
0617 2853
0618 2853 0B                    phd                            Save our local D-page
0619 2854
0620 2854              ; Put the windPtr (the real one) on window managers
0621 2854              ; direct page.
0622 2854 A6 01                 ldx   WindMgrD
0623 2856 A5 09                 lda   WindPtr
0624 2858 9F A6 00 00           sta   >Wind,x
0625 285C A5 0B                 lda   WindPtr+2
0626 285E 9F A8 00 00           sta   >Wind+2,x
0627 2862
0628 2862 A6 1C                 ldx   <InputTaskRecPtr         Pass pointer to task record.
0629 2864 A4 1E                 ldy   <InputTaskRecPtr+2
0630 2866 A9 21 00              lda   #wTask                   Pass command.
0631 2869 D4 01                 pei   WindMgrD                 Make WindMgr D-Page current
0632 286B 2B                    pld   
0633 286C 20 D5 11              jsr   callProc2
0634 286F
0635 286F 2B                    pld                            Restore our local D-page
0636 2870              ;                                       a = result, x = action taken.
0637 2870              ;
0638 2870 C9 13 00     ckControls cmp   #wInContent
0639 2873 D0 0F                 bne   skip7
0640 2875
0641 2875 48                    pha   
0642 2876 48                    pha   
0643 2877 D4 1E                 pei   <InputTaskRecPtr+2
0644 2879 D4 1C                 pei   <InputTaskRecPtr
0645 287B A2 0E 5D 22           _TaskMasterContent 
0646 2882
0647 2882              joinTMContent  
0648 2882 FA                    plx                            ; action take
0649 2883 68                    pla                            ; result code
0650 2884
0651 2884
0652 2884 86 03        skip7    stx   <ThisAction
0653 2886 AA                    tax   
0654 2887
0655 2887
0656 2887
0657 2887              ; --- Return to caller --------------------------------------------
0658 2887              ;
0659 2887              ; X-reg contains the value to be put in OutputTaskCode and
0660 2887              ; ThisAction contains the value of the taskCode acted on if
0661 2887              ; OutputTaskCode is zero.
0662 2887              ;
0663 2887              GoHome    
0664 2887 86 22                 stx   OutputTaskCode           Return result to caller
0665 2889
0666 2889 8A                    txa                            Null event?
0667 288A D0 07                 bne   UnlinkWithoutError
0668 288C
0669 288C A5 03                 lda   <ThisAction
0670 288E A0 10 00              ldy   #TaskData                Return action performed in TaskData.
0671 2891 97 1C                 sta   [<InputTaskRecPtr],y
0672 2893              ;
0673 2893              UnLinkWithoutError  
0674 2893 A0 00 00              ldy   #0                       Indicate No Error
0675 2896
0676 2896
0677 2896              UnLinkWithError  
0678 2896 84 01                 sty   WindMgrD                 Save error  for momment
0679 2898 A2 04 1B 22           _SetPort                       restore port from stack
0680 289F A4 01                 ldy   WindMgrD                 Get error back
0681 28A1
0682 28A1 68                    pla                            Pull off WindMgrs D
0683 28A2 68                    pla                            Pull off ThisAction
0684 28A3
0685 28A3 68                    pla                            Pull Off TaskMask
0686 28A4 68                    pla   
0687 28A5
0688 28A5 68                    pla                            Pull Off window pointer
0689 28A6 68                    pla   
0690 28A7
0691 28A7 68                    pla                            Pull Off window manager globals
0692 28A8 68                    pla   
0693 28A9
0694 28A9 68                    pla                            Pull off Calling Flag
0695 28AA
0696 28AA              ; dbr already on stack!
0697 28AA
0698 28AA 82 11 67              brl   epop6bytes
0699 28AD              ;
0700 28AD              ;
0701 28AD
0702 28AD
0703 28AD 80 00        masks    DC W:TM_CONTENT                $0013     0 wInContent
0704 28AF 40 00                 DC W:TM_DRAGW                  $0014     1 wInDrag
0705 28B1 00 04                 DC W:TM_GROW                   $0015     2 wInGrow
0706 28B3 00 01                 DC W:TM_CLOSE                  $0016     3 wInGoAway
0707 28B5 00 02                 DC W:TM_ZOOM                   $0017     4 wInZoom
0708 28B7 00 80                 DC W:TM_INFO                   $0018     5 wInInfo
0709 28B9 00 00                 DC W:0                         $0019     6 wInSpecial
0710 28BB 00 00                 DC W:0                         $001A     7 wInDeskItem
0711 28BD 00 08                 DC W:TM_SCROLL                 $001B     8 wInDeskItem
0712 28BF              ;
0713 28BF                       ENDP 
0714 28BF
0715 28BF
0716 28BF
0717 28BF
0718 28BF                       title 'TaskMasterContent' 
0719 28BF              ****************************************************************
0720 28BF              *
0721 28BF              TaskMasterContent   PROC EXPORT  
0722 28BF              *
0723 28BF              * Description
0724 28BF              *
0725 28BF              *
0726 28BF              * Inputs:
0727 28BF              *                   none
0728 28BF              *                   taskData = window to track controls in.
0729 28BF              *
0730 28BF              * Outputs:
0731 28BF              *                   none
0732 28BF              *
0733 28BF              * External Refs:
0734 28BF                       import InvertIfNecessary 
0735 28BF              *
0736 28BF              * Entry Points:
0737 28BF              *                   none
0738 28BF              *
0739 28BF                       longa on                       ; mode
0740 28BF                       longi on
0741 28BF              *
0742 28BF              *
0743 28BF              * Change History
0744 28BF              *
0745 28BF              * 19 Apr 89         Steven Glass
0746 28BF              *
0747 28BF              * Treat scroll bars specially so that after tracking the control, 
0748 28BF              * we always return the part code of the scroll bar.
0749 28BF              *
0750 28BF              * The problem arrised if you tracked the scroll for a while and
0751 28BF              * then pulled out.  The app might think nothing happend.
0752 28BF              *
0753 28BF              * Worksheet # BCOJHS111
0754 28BF              *
0755 28BF              ****************************************************************
0756 28BF                             DefineStack  
0757 28BF              TMsD           word  
0758 28BF              MyTemp         long  
0759 28BF              Ret1           block 3  
0760 28BF              Ret2           block 3  
0761 28BF              Event          long  
0762 28BF              Result         long  
0763 28BF
0764 28BF 48                    pha   
0765 28C0 48                    pha   
0766 28C1
0767 28C1 0B                    phd   
0768 28C2 3B                    tsc   
0769 28C3 5B                    tcd   
0770 28C4
0771 28C4
0772 28C4              ;-----------------------------------------------------------
0773 28C4              ;
0774 28C4              ; Assume that there are no controls.
0775 28C4              ;
0776 28C4
0777 28C4 A9 13 00              lda   #wInContent
0778 28C7 85 13                 sta   Result+2
0779 28C9 64 11                 stz   Result
0780 28CB
0781 28CB              ;-----------------------------------------------------------
0782 28CB              ;
0783 28CB              ; Look and see if program wants me to look for controls
0784 28CB              ;
0785 28CB A0 16 00              ldy   #NewTaskRecord.TaskMask+2
0786 28CE B7 0D                 lda   [<event],y
0787 28D0 29 01 00              and   #tmContentControls
0788 28D3 D0 03                 bne   LookForControls
0789 28D5
0790 28D5 82 EB 00              brl   CleanStack
0791 28D8
0792 28D8              ;
0793 28D8              ;
0794 28D8              ; --- Only look for controls in top window.
0795 28D8              ;
0796 28D8              LookForControls  
0797 28D8 48                    pha                            Space for result.
0798 28D9 48                    pha   
0799 28DA A2 0E 15 22           _FrontWindow 
0800 28E1 68                    pla   
0801 28E2 FA                    plx   
0802 28E3 A0 10 00              ldy   #taskData
0803 28E6 D7 0D                 cmp   [<event],y
0804 28E8 D0 07                 bne   @exit
0805 28EA 8A                    txa   
0806 28EB C8                    iny   
0807 28EC C8                    iny   
0808 28ED D7 0D                 cmp   [<event],y
0809 28EF F0 03                 beq   @ok1
0810 28F1 82 CF 00     @exit    brl   CleanStack
0811 28F4              @ok1      
0812 28F4
0813 28F4
0814 28F4              ;-----------------------------------------------------------
0815 28F4              ;
0816 28F4              ; The program wants me to look for controls, so I start
0817 28F4              ; by zeroing out the output fields in the task record.
0818 28F4              ;
0819 28F4              ; Zero taskData2, taskData3 and taskData4
0820 28F4              ;
0821 28F4              ;
0822 28F4 A0 1E 00              ldy   #NewTaskRecord.taskData2
0823 28F7 A9 00 00              lda   #0
0824 28FA 97 0D        Loop     sta   [<event],y
0825 28FC C8                    iny   
0826 28FD C8                    iny   
0827 28FE C0 2A 00              cpy   #NewTaskRecord.taskData2+12
0828 2901 90 F7                 bcc   Loop
0829 2903
0830 2903              ;-----------------------------------------------------------
0831 2903              ;
0832 2903              ; Before trying to find the control, fix the window 
0833 2903              ; coordinate system.
0834 2903              ;
0835 2903 20 D9 29              jsr   PushWPtr
0836 2906 A2 0E 4D 22           _StartDrawing 
0837 290D
0838 290D
0839 290D              ;-----------------------------------------------------------
0840 290D              ;
0841 290D              ; Call find control
0842 290D              ;
0843 290D 48                    pha   
0844 290E A5 0D                 lda   <event                   Pointer to TaskData2
0845 2910 18                    clc   
0846 2911 69 1E 00              adc   #NewTaskRecord.taskData2
0847 2914 AA                    tax   
0848 2915 A5 0F                 lda   <event+2
0849 2917 69 00 00              adc   #0
0850 291A 48                    pha   
0851 291B DA                    phx   
0852 291C A0 0C 00              ldy   #where+2                 Pass point where button down.
0853 291F B7 0D                 lda   [<event],y
0854 2921 48                    pha   
0855 2922 88                    dey   
0856 2923 88                    dey   
0857 2924 B7 0D                 lda   [<event],y
0858 2926 48                    pha                            Find if down on window.
0859 2927 20 D9 29              jsr   PushWPtr
0860 292A A2 10 13 22           _FindControl 
0861 2931 68                    pla   
0862 2932
0863 2932 A0 22 00              ldy   #NewTaskRecord.taskData3
0864 2935 97 0D                 sta   [<event],y
0865 2937 A8                    tay                            Was anything found?
0866 2938 D0 03                 bne   FoundAControl
0867 293A
0868 293A 82 68 00              brl   NoControlFound
0869 293D              FoundAControl  
0870 293D              ;-----------------------------------------------------------
0871 293D              ;
0872 293D              ; put ControlID into taskData4
0873 293D              ;
0874 293D 48                    pha                            Get control ID
0875 293E 48                    pha   
0876 293F A0 20 00              ldy   #NewTaskRecord.taskData2+2
0877 2942 B7 0D                 lda   [<event],y
0878 2944 48                    pha   
0879 2945 88                    dey   
0880 2946 88                    dey   
0881 2947 B7 0D                 lda   [<event],y
0882 2949 48                    pha   
0883 294A A2 10 2A 22           _GetCtlID 
0884 2951 68                    pla   
0885 2952 FA                    plx   
0886 2953 B0 0A                 bcs   NoID
0887 2955 A0 26 00              ldy   #NewTaskRecord.taskData4
0888 2958 97 0D                 sta   [<event],y
0889 295A C8                    iny   
0890 295B C8                    iny   
0891 295C 8A                    txa   
0892 295D 97 0D                 sta   [<event],y
0893 295F
0894 295F              NoID      
0895 295F
0896 295F
0897 295F              ;-----------------------------------------------------------
0898 295F              ;
0899 295F              ; Track the control
0900 295F              ;
0901 295F
0902 295F 48                    pha   
0903 2960 A0 0C 00              ldy   #where+2                 Pass point where button down.
0904 2963 B7 0D                 lda   [<event],y
0905 2965 48                    pha   
0906 2966 88                    dey   
0907 2967 88                    dey   
0908 2968 B7 0D                 lda   [<event],y
0909 296A 48                    pha                            Find if down on window.
0910 296B F4 FF FF              pea   $FFFF
0911 296E F4 FF FF              pea   $FFFF
0912 2971 20 DF 29              jsr   PushTaskData2
0913 2974 A2 10 15 22           _TrackControl 
0914 297B
0915 297B              ;
0916 297B              ; was this a scroll bar (but not the thumb)
0917 297B              ;
0918 297B A0 22 00              ldy   #newTaskRecord.TaskData3
0919 297E B7 0D                 lda   [<event],y
0920 2980 C9 05 00              cmp   #upArrow
0921 2983 90 08                 bcc   NotScroll
0922 2985 C9 09 00              cmp   #pageDown+1
0923 2988 B0 03                 bcs   NotScroll
0924 298A
0925 298A 68                    pla   
0926 298B 80 03                 bra   YesScroll
0927 298D
0928 298D              NotScroll  
0929 298D 68                    pla   
0930 298E F0 1D                 beq   GaveUp
0931 2990
0932 2990
0933 2990              YesScroll  
0934 2990 A0 24 00              ldy   #newTaskRecord.TaskData3+2
0935 2993 97 0D                 sta   [<event],y
0936 2995
0937 2995              ;-----------------------------------------------------------
0938 2995              ;
0939 2995              ; If the type is a check control or a radio control, 
0940 2995              ; then we have to diddle with its value.
0941 2995              ;
0942 2995
0943 2995 20 DF 29              jsr   PushTaskData2
0944 2998 68                    pla   
0945 2999 FA                    plx   
0946 299A
0947 299A 20 90 2C              jsr   InvertIfNecessary
0948 299D
0949 299D A9 21 00              lda   #wInControl
0950 29A0 A2 00 00              ldx   #0
0951 29A3 80 0E                 bra   GetOut
0952 29A5
0953 29A5
0954 29A5
0955 29A5              NoControlFound  
0956 29A5 A9 13 00              lda   #wInContent
0957 29A8 A2 00 00              ldx   #0
0958 29AB 80 06                 bra   GetOut
0959 29AD
0960 29AD
0961 29AD A9 00 00     GaveUp   lda   #0
0962 29B0 A2 13 00              ldx   #wInContent
0963 29B3
0964 29B3              GetOut    
0965 29B3 85 13                 sta   Result+2
0966 29B5 86 11                 stx   Result
0967 29B7
0968 29B7 A9 00 00              lda   #0
0969 29BA 48                    pha   
0970 29BB 48                    pha   
0971 29BC A2 04 23 22           _SetOrigin 
0972 29C3
0973 29C3              CleanStack  
0974 29C3
0975 29C3 A5 0B                 lda   Ret1+4                   ; move the rtl address up 4 bytes
0976 29C5 85 0F                 sta   Ret1+4+4
0977 29C7 A5 09                 lda   Ret1+2
0978 29C9 85 0D                 sta   Ret1+2+4
0979 29CB A5 07                 lda   Ret1
0980 29CD 85 0B                 sta   Ret1+4
0981 29CF 2B                    pld                            ; restore d-reg
0982 29D0
0983 29D0 68                    pla                            ; clean off 4 bytes of temp storage
0984 29D1 68                    pla   
0985 29D2
0986 29D2 68                    pla                            ; clean off 4bytes of input
0987 29D3 68                    pla   
0988 29D4
0989 29D4 A9 00 00              lda   #0                       ; return no error
0990 29D7 18                    clc   
0991 29D8 6B                    rtl   
0992 29D9
0993 29D9
0994 29D9              PushWPtr  
0995 29D9 FA                    plx   
0996 29DA A0 12 00              ldy   #NewTaskRecord.TaskData+2
0997 29DD 80 04                 bra   JoinPusher
0998 29DF              PushTaskData2  
0999 29DF FA                    plx   
1000 29E0
1001 29E0 A0 20 00              ldy   #NewTaskRecord.TaskData2+2
1002 29E3 B7 0D        JoinPusher lda   [<event],y
1003 29E5 48                    pha   
1004 29E6 88                    dey   
1005 29E7 88                    dey   
1006 29E8 B7 0D                 lda   [<event],y
1007 29EA 48                    pha   
1008 29EB
1009 29EB DA                    phx   
1010 29EC
1011 29EC 60                    rts   
1012 29ED
1013 29ED                       ENDP 
1014 29ED
1015 29ED
1016 29ED                       title 'TaskMasterKey' 
1017 29ED              ****************************************************************
1018 29ED              *
1019 29ED              TaskMasterKey PROC EXPORT 
1020 29ED              *
1021 29ED              * This is the routine that handles keystrokes.  We've broken
1022 29ED              * it out from the rest of task master so that it will be 
1023 29ED              * easy to patch (if necessary).
1024 29ED              *
1025 29ED              *
1026 29ED              * Inputs:
1027 29ED              *     Space For result         LONG
1028 29ED              *     Pointer To TaskRec       LONG
1029 29ED              *     Pointer To Front Window  LONG
1030 29ED              *
1031 29ED              * Outputs:
1032 29ED              *     HiWord  Function Result for TaskMaster
1033 29ED              *     LoWORD  Original Event we handled
1034 29ED              *
1035 29ED              *
1036 29ED              * External Refs:
1037 29ED                       import task_menu2 
1038 29ED                       import InvertIfNecessary 
1039 29ED              *
1040 29ED              * Entry Points:
1041 29ED              *                   none
1042 29ED              *
1043 29ED                       longa on                       ; mode
1044 29ED                       longi on
1045 29ED              *
1046 29ED              *
1047 29ED              * Change History
1048 29ED              *
1049 29ED              * 01 Dec 88         Steven Glass
1050 29ED              *
1051 29ED              * Checked to see if there was a top window before calling trying
1052 29ED              * to send keystrokes to it.
1053 29ED              *
1054 29ED              * 08 Feb 89         Harry Yee
1055 29ED              *
1056 29ED              * If DATaskFlag is negative, then we were called by TaskMasterDA otherwise
1057 29ED              * we were just called by TaskMaster. If we were called by TaskMasterDA then
1058 29ED              * then the top window must be a system window otherwise the key event is
1059 29ED              * not passed on. If we were called by TaskMaster then the top window cannot
1060 29ED              * be a system window otherwise the key event will not get passed on.
1061 29ED              *
1062 29ED              *
1063 29ED              * 15 Feb 89         Dave Good
1064 29ED              *
1065 29ED              * The last change didn't work; harry gave me some new code and I implemented
1066 29ED              * it. Key events should be passed to the controls properly now.
1067 29ED              *
1068 29ED              * 19 Feb 89         Steven Glass
1069 29ED              *
1070 29ED              * Called invertIfNeccessary if inControl is returned for keystrokes.
1071 29ED              *
1072 29ED              * 20 Feb 89         Steven Glass
1073 29ED              *
1074 29ED              * If the original calling program is TaskMasterDA, then we do
1075 29ED              * not send the keystroke to MenuKey.
1076 29ED              *
1077 29ED              * 13 Mar 89         Steven Glass and Harry Yee
1078 29ED              *
1079 29ED              * The origin was being set to zero before InvertIfNecessary was called.
1080 29ED              * This would cause controls to be drawn incorrectly. BRC #45532, 45533.
1081 29ED              *
1082 29ED              * 19 Apr 89         Steven Glass and Harry Yee
1083 29ED              *
1084 29ED              * TaskMaster could not return wClosedNDA, wCalledSysEdit, wInControlMenu
1085 29ED              * or wInDeskItem.  This was caused by TaskMenu2's return of the action
1086 29ED              * taken being ignored here.  So now we look at it if the action is taken.
1087 29ED              *
1088 29ED              ****************************************************************
1089 29ED                             DefineStack  
1090 29ED              TMsD           word  
1091 29ED              Ret1           block 3  
1092 29ED              Ret2           block 3  
1093 29ED              TheTopWind     long  
1094 29ED              Event          long  
1095 29ED              Result         long  
1096 29ED
1097 29ED
1098 29ED 0B                    phd   
1099 29EE 3B                    tsc   
1100 29EF 5B                    tcd   
1101 29F0
1102 29F0
1103 29F0              ;-----------------------------------------------------------
1104 29F0              ;
1105 29F0              ; Start by copy the event to result.
1106 29F0              ;
1107 29F0 A0 00 00              ldy   #NewTaskRecord.taskWhat
1108 29F3 B7 0D                 lda   [event],y
1109 29F5 85 11                 sta   Result
1110 29F7 85 13                 sta   Result+2
1111 29F9
1112 29F9
1113 29F9              ;-----------------------------------------------------------
1114 29F9              ;
1115 29F9              ; Now see if the key is a menu key.
1116 29F9              ;
1117 29F9              TryMenus  
1118 29F9
1119 29F9 A6 01                 ldx   TMsD
1120 29FB BF 11 00 00           lda   >CallingFlag,x
1121 29FF D0 34                 bne   CannotBeMenuKey
1122 2A01
1123 2A01 A0 14 00              ldy   #NewTaskRecord.taskmask
1124 2A04 B7 0D                 lda   [event],y
1125 2A06 29 01 00              and   #TM_MENUKEY
1126 2A09 F0 2A                 beq   TryCtlKey
1127 2A0B              ;
1128 2A0B D4 0F        ok30     pei   <event+2                 Pass pointer to event.
1129 2A0D D4 0D                 pei   <event
1130 2A0F A9 00 00              lda   #0                       Pass pointer to menu bar,
1131 2A12 48                    pha                            zero = system menu bar.
1132 2A13 48                    pha   
1133 2A14 A2 0F 09 22           _MenuKey 
1134 2A1B
1135 2A1B 0B                    phd                            Switch TaskMasters D back in and call...
1136 2A1C A5 01                 lda   TMsD
1137 2A1E 5B                    tcd   
1138 2A1F
1139 2A1F A2 03 00              ldx   #inKey                   Just in case its not a menu
1140 2A22 86 03                 stx   <ThisAction              Init this field too
1141 2A24 20 54 2B              jsr   task_menu2
1142 2A27
1143 2A27 A5 03                 lda   <ThisAction
1144 2A29
1145 2A29 2B                    pld                            restore my d-page
1146 2A2A
1147 2A2A 86 13                 stx   Result+2
1148 2A2C E0 03 00              cpx   #inKey
1149 2A2F F0 04                 beq   TryCtlKey                keep trying
1150 2A31
1151 2A31 85 11                 sta   Result
1152 2A33 80 7E                 bra   GetOut
1153 2A35
1154 2A35
1155 2A35
1156 2A35              CannotBeMenuKey  
1157 2A35
1158 2A35              TryCtlKey  
1159 2A35              ;-----------------------------------------------------------
1160 2A35              ;
1161 2A35              ; See if the user wants to send key to controls.
1162 2A35              ;
1163 2A35
1164 2A35
1165 2A35 A0 04 00              ldy   #4                       ;four bytes into the window is a flag that tells us whether
1166 2A38 B7 09                 lda   [<TheTopWind],y          ;..this is a system or application window
1167 2A3A A6 01                 ldx   TMsD
1168 2A3C 5F 11 00 00           eor   >CallingFlag,x           ;..window and TaskMaster then pass key, otherwise exit
1169 2A40 29 00 80              and   #$8000                   ;if system window and TaskDA then pass key. If application
1170 2A43 F0 03                 beq   @WeMatch
1171 2A45 82 6B 00              brl   GetOut
1172 2A48
1173 2A48 BF 07 00 00  @WeMatch lda   >TheTaskMask+2,x
1174 2A4C 29 02 00              and   #TMcontrolKey
1175 2A4F F0 62                 beq   GetOut
1176 2A51
1177 2A51              ;-----------------------------------------------------------
1178 2A51              ;
1179 2A51              ; Zero taskData2, taskData3 and taskData4
1180 2A51              ;
1181 2A51 A0 1E 00              ldy   #NewTaskRecord.taskData2
1182 2A54 A9 00 00              lda   #0
1183 2A57 97 0D        Loop     sta   [<event],y
1184 2A59 C8                    iny   
1185 2A5A C8                    iny   
1186 2A5B C0 2A 00              cpy   #NewTaskRecord.taskData2+12
1187 2A5E 90 F7                 bcc   Loop
1188 2A60
1189 2A60
1190 2A60              ;-----------------------------------------------------------
1191 2A60              ;
1192 2A60              ; Lets see if there even is a window
1193 2A60              ;
1194 2A60 A5 09                 lda   TheTopWind
1195 2A62 05 0B                 ora   TheTopWind+2
1196 2A64 F0 4D                 beq   GetOut
1197 2A66
1198 2A66              ;-----------------------------------------------------------
1199 2A66              ;
1200 2A66              ; Before doing anything else, fix the window 
1201 2A66              ; coordinate system.
1202 2A66              ;
1203 2A66 D4 0B                 pei   TheTopWind+2
1204 2A68 D4 09                 pei   TheTopWind
1205 2A6A A2 0E 4D 22           _StartDrawing 
1206 2A71
1207 2A71
1208 2A71              ;-----------------------------------------------------------
1209 2A71              ;
1210 2A71              ; Now we send the key to the controls
1211 2A71              ;
1212 2A71 48                    pha   
1213 2A72 F4 00 00              PushWord #False 
1214 2A75 D4 0B                 pei   TheTopWind+2
1215 2A77 D4 09                 pei   TheTopWind
1216 2A79 D4 0F                 pei   event+2
1217 2A7B D4 0D                 pei   event
1218 2A7D A2 10 29 22           _SendEventToCtl 
1219 2A84
1220 2A84              ;-----------------------------------------------------------
1221 2A84              ;
1222 2A84              ; Look at the result
1223 2A84              ;
1224 2A84 68                    pla   
1225 2A85 F0 20                 beq   ZeroAndGetOut
1226 2A87
1227 2A87 A9 21 00              lda   #wInControl
1228 2A8A 85 13                 sta   Result+2
1229 2A8C
1230 2A8C              ;-----------------------------------------------------------
1231 2A8C              ;
1232 2A8C              ; Added 3/15/89     Mensch
1233 2A8C              ; Return the front window pointer in taskData because a control in
1234 2A8C              ; that window was just messed with.
1235 2A8C
1236 2A8C A0 10 00              ldy   #TaskData                ; offset to taskdata in the event record
1237 2A8F A5 09                 lda   <TheTopWind              ; place the top window pointer into task data
1238 2A91 97 0D                 sta   [<event],y
1239 2A93 A0 12 00              ldy   #TaskData+2
1240 2A96 A5 0B                 lda   <TheTopWind+2
1241 2A98 97 0D                 sta   [<event],y
1242 2A9A              ; End of change
1243 2A9A
1244 2A9A A0 20 00              ldy   #NewTaskRecord.TaskData2+2
1245 2A9D B7 0D                 lda   [event],y
1246 2A9F AA                    tax   
1247 2AA0 88                    dey   
1248 2AA1 88                    dey   
1249 2AA2 B7 0D                 lda   [event],y
1250 2AA4 20 90 2C              jsr   InvertIfNecessary
1251 2AA7
1252 2AA7              ZeroAndGetOut  
1253 2AA7              ;-----------------------------------------------------------
1254 2AA7              ;
1255 2AA7              ; Fix the origin
1256 2AA7 A9 00 00              lda   #0
1257 2AAA 48                    pha   
1258 2AAB 48                    pha   
1259 2AAC A2 04 23 22           _SetOrigin 
1260 2AB3
1261 2AB3              GetOut    
1262 2AB3 A5 07                 lda   Ret1+4                   ; move the rtl address up 4 bytes
1263 2AB5 85 0F                 sta   Ret1+4+8
1264 2AB7 A5 05                 lda   Ret1+2
1265 2AB9 85 0D                 sta   Ret1+2+8
1266 2ABB A5 03                 lda   Ret1
1267 2ABD 85 0B                 sta   Ret1+8
1268 2ABF 2B                    pld                            ; restore d-reg
1269 2AC0
1270 2AC0 68                    pla                            ; clean off 8 bytes of input
1271 2AC1 68                    pla   
1272 2AC2 68                    pla   
1273 2AC3 68                    pla   
1274 2AC4
1275 2AC4 A9 00 00              lda   #0                       ; return no error
1276 2AC7 18                    clc   
1277 2AC8 6B                    rtl   
1278 2AC9
1279 2AC9
1280 2AC9
1281 2AC9                       endp 
1282 2AC9
1283 2AC9
1284 2AC9                       title 'TaskMasterDA' 
1285 2AC9              ****************************************************************
1286 2AC9              *
1287 2AC9              TaskMasterDA PROC EXPORT 
1288 2AC9              *
1289 2AC9              * This is the routine that can be called by desk accessories
1290 2AC9              * that to let TaskMaster do its work for it.
1291 2AC9              *
1292 2AC9              *
1293 2AC9              * Inputs:
1294 2AC9              *     Space For result         WORD
1295 2AC9              *     DummyWord                WORD
1296 2AC9              *     Pointer To TaskRec       LONG
1297 2AC9              *
1298 2AC9              * Outputs:
1299 2AC9              *     WORD    ResultCode (same as task master
1300 2AC9              *
1301 2AC9              *
1302 2AC9              * External Refs:
1303 2AC9              *                   import task_menu2
1304 2AC9              *
1305 2AC9              * Entry Points:
1306 2AC9              *                   none
1307 2AC9              *
1308 2AC9                       longa on                       ; mode
1309 2AC9                       longi on
1310 2AC9              *
1311 2AC9              ****************************************************************
1312 2AC9
1313 2AC9 0B                    phd                            Save d-page and dbr on stack
1314 2ACA 8B                    phb   
1315 2ACB 5B                    tcd                            Switch in wmgr's dPage for a momment
1316 2ACC
1317 2ACC F4 FF FF              pea   $FFFF                    Push CallingFlag of -1 to indicate call origin
1318 2ACF
1319 2ACF 82 B8 FB              brl   DAEntry
1320 2AD2
1321 2AD2
1322 2AD2                       endp 
1323 2AD2
1324 2AD2
1325 2AD2                       title 'BreakOut' 
1326 2AD2              ****************************************************************
1327 2AD2              *
1328 2AD2              breakout PROC 
1329 2AD2              *
1330 2AD2              * Gets window pointer from event record and puts it into WindPtr.
1331 2AD2              *
1332 2AD2              *
1333 2AD2              * Inputs:
1334 2AD2              *                   InputTaskRecPtr
1335 2AD2              *
1336 2AD2              * Outputs:
1337 2AD2              *                   WindPtr
1338 2AD2              *
1339 2AD2              * External Refs:
1340 2AD2              *                   none
1341 2AD2              *
1342 2AD2              * Entry Points:
1343 2AD2              *                   none
1344 2AD2              *
1345 2AD2                       longa on                       ; mode
1346 2AD2                       longi on
1347 2AD2              *
1348 2AD2              ****************************************************************
1349 2AD2
1350 2AD2 A0 10 00              ldy   #TaskData
1351 2AD5 B7 1C                 lda   [<InputTaskRecPtr],y
1352 2AD7 85 09                 sta   <WindPtr
1353 2AD9 C8                    iny   
1354 2ADA C8                    iny   
1355 2ADB B7 1C                 lda   [<InputTaskRecPtr],y
1356 2ADD 85 0B                 sta   <WindPtr+2
1357 2ADF
1358 2ADF 60                    rts   
1359 2AE0
1360 2AE0                       ENDP 
1361 2AE0
1362 2AE0
1363 2AE0                       title 'do_update2' 
1364 2AE0              ****************************************************************
1365 2AE0              *
1366 2AE0              do_update2 PROC 
1367 2AE0              *
1368 2AE0              * Have the application draw the update region
1369 2AE0              *
1370 2AE0              *
1371 2AE0              * Inputs:
1372 2AE0              *                   WindPtr is pointer to window's grafPort
1373 2AE0              *                   OrigD 
1374 2AE0              *
1375 2AE0              * Outputs:
1376 2AE0              *                   a-reg:  0 if update was handled
1377 2AE0              *                           wInUpdate if not handled
1378 2AE0              *
1379 2AE0              * External Refs:
1380 2AE0                       import LongCall 
1381 2AE0                       import ZeroOrigin 
1382 2AE0              *
1383 2AE0              * Entry Points:
1384 2AE0              *                   none
1385 2AE0              *
1386 2AE0                       longa on                       ; mode
1387 2AE0                       longi on
1388 2AE0              *
1389 2AE0              * Change History
1390 2AE0              *
1391 2AE0              * 23 Feb 89         Steven Glass
1392 2AE0              *
1393 2AE0              * In original implementation of this routine, shared
1394 2AE0              * direct page made it possible to call internal window manager
1395 2AE0              * routines rather than the making real calls.
1396 2AE0              *
1397 2AE0              * The stack based re-write made us make real calls including
1398 2AE0              *
1399 2AE0              *     BeginUpdate
1400 2AE0              *     StartDrawing
1401 2AE0              *     ZeroOrigin
1402 2AE0              *     EndUpdate
1403 2AE0              *
1404 2AE0              *
1405 2AE0              ****************************************************************
1406 2AE0
1407 2AE0 A2 06 00              ldx   #inUpdate
1408 2AE3 A0 B6 00              ldy   #wContDraw               Is there an address of a redraw routine?
1409 2AE6 B7 09                 lda   [<WindPtr],y
1410 2AE8 C8                    iny   
1411 2AE9 17 09                 ora   [<WindPtr],y
1412 2AEB F0 3C                 beq   exit
1413 2AED              ;
1414 2AED 20 2B 2B              jsr   PushWinPtr
1415 2AF0 A2 0E 1E 22           _BeginUpdate 
1416 2AF7
1417 2AF7 20 2B 2B              jsr   PushWinPtr
1418 2AFA A2 0E 4D 22           _StartDrawing 
1419 2B01
1420 2B01              ;
1421 2B01 A0 B7 00              ldy   #wContDraw+1             Get address of draw routine.
1422 2B04 B7 09                 lda   [<WindPtr],y
1423 2B06 AA                    tax   
1424 2B07 88                    dey   
1425 2B08 B7 09                 lda   [<WindPtr],y
1426 2B0A              ;
1427 2B0A 0B                    phd                            Save my zero page.
1428 2B0B 8B                    phb                            Save current data bank.
1429 2B0C              ;
1430 2B0C D4 12                 pei   OrigB-1
1431 2B0E AB                    plb   
1432 2B0F AB                    plb   
1433 2B10 D4 14                 pei   OrigD
1434 2B12 2B                    pld   
1435 2B13
1436 2B13 22 67 22 FD           jsl   longCall
1437 2B17              ;
1438 2B17 AB                    plb                            Restore last data bank.
1439 2B18 2B                    pld                            Switch to my zero page.
1440 2B19              ;
1441 2B19
1442 2B19 20 6E 22              jsr   ZeroOrigin
1443 2B1C
1444 2B1C 20 2B 2B              jsr   PushWinPtr
1445 2B1F A2 0E 1F 22           _EndUpdate 
1446 2B26              ;
1447 2B26 A2 00 00              ldx   #0                       Null event, event handled flag.
1448 2B29              ;
1449 2B29 8A           exit     txa                            Return event flag in A.
1450 2B2A 60                    rts   
1451 2B2B
1452 2B2B
1453 2B2B              PushWinPtr  
1454 2B2B FA                    plx   
1455 2B2C A0 12 00              ldy   #TaskData+2
1456 2B2F B7 1C                 lda   [InputTaskRecPtr],y
1457 2B31 48                    pha   
1458 2B32 88                    dey   
1459 2B33 88                    dey   
1460 2B34 B7 1C                 lda   [InputTaskRecPtr],y
1461 2B36 48                    pha   
1462 2B37 DA                    phx   
1463 2B38 60                    rts   
1464 2B39
1465 2B39
1466 2B39                       ENDP 
1467 2B39
1468 2B39
1469 2B39                       title 'task_menu' 
1470 2B39              ****************************************************************
1471 2B39              *
1472 2B39              task_menu PROC 
1473 2B39              *
1474 2B39              * Handles system menu bar interactions for TaskMaster.
1475 2B39              *
1476 2B39              *
1477 2B39              * Inputs:
1478 2B39              *                   x-reg   wInMenuBar
1479 2B39              *
1480 2B39              * Outputs:
1481 2B39              *                   x-reg   Task master return code
1482 2B39              *
1483 2B39              * External Refs:
1484 2B39                       import PushFrontWindow 
1485 2B39              *
1486 2B39              * Entry Points:
1487 2B39              *                   none
1488 2B39              *
1489 2B39                       longa on                       ; mode
1490 2B39                       longi on
1491 2B39              *
1492 2B39              ****************************************************************
1493 2B39
1494 2B39 A5 05                 lda   <TheTaskMask             Ok to call MenuSelect?
1495 2B3B 29 08 00              and   #TM_MENUSLT
1496 2B3E D0 01                 bne   ok1
1497 2B40 60           exit1    rts                            MenuSelect handler is masked off.
1498 2B41              ;
1499 2B41 D4 1E        ok1      pei   <InputTaskRecPtr+2       Pass pointer to event record.
1500 2B43 D4 1C                 pei   <InputTaskRecPtr
1501 2B45 A9 00 00              lda   #0                       System menu bar flag.
1502 2B48 48                    pha   
1503 2B49 48                    pha   
1504 2B4A A2 0F 2B 22           _MenuSelect                    Let user make a selection.
1505 2B51              ;
1506 2B51 A2 00 00              ldx   #Null                    Just in case.
1507 2B54              ;
1508 2B54              ;
1509 2B54                       ENTRY task_menu2 
1510 2B54              task_menu2       
1511 2B54              ;
1512 2B54 A0 10 00              ldy   #TaskData                See if there was a selection.
1513 2B57 B7 1C                 lda   [<InputTaskRecPtr],y
1514 2B59 D0 11                 bne   selection
1515 2B5B              ;
1516 2B5B A5 05                 lda   <TheTaskMask             Allow selection of inactive menu items?
1517 2B5D 29 00 40              and   #TM_INACTIVE
1518 2B60 F0 DE                 beq   exit1
1519 2B62              ;
1520 2B62 C8                    iny   
1521 2B63 C8                    iny   
1522 2B64 B7 1C                 lda   [<InputTaskRecPtr],y     Inactive item selected?
1523 2B66 F0 D8                 beq   exit1
1524 2B68              ;
1525 2B68 A2 1C 00              ldx   #wInactMenu              Inactive item selected event.
1526 2B6B 60                    rts                            No selection made.
1527 2B6C
1528 2B6C
1529 2B6C              ;
1530 2B6C              ; --- Handle special menu selection -----------------------------------------
1531 2B6C              ;
1532 2B6C A2 11 00     selection ldx   #wInMenuBar             Application menu selection made.
1533 2B6F              ;
1534 2B6F C9 00 01              cmp   #256                     Special or desk accessory item ID?
1535 2B72 B0 51                 bcs   doCtrlMenu               IDs greater than 255 are application's.
1536 2B74              ;
1537 2B74 C9 FA 00              cmp   #250                     Special or Desk accessory item ID?
1538 2B77 B0 03 82 85           bccl desk_item
1539 2B7C              ;
1540 2B7C              ;
1541 2B7C              ; ------ Special Undo, Cut, Copy, Paste, Clear, Close item ------------------
1542 2B7C              ;
1543 2B7C A5 05                 lda   <TheTaskMask
1544 2B7E 29 00 10              and   #TM_SPECIAL              Ok to handle it?
1545 2B81 F0 3E                 beq   skip4
1546 2B83              ;
1547 2B83 48                    pha   
1548 2B84 20 33 2C              jsr   PushFrontWindow
1549 2B87 A2 0E 4C 22           _GetSysWFlag 
1550 2B8E 68                    pla   
1551 2B8F
1552 2B8F D0 03 82 68           beqL doCtrlSpecial             Application window if positive.
1553 2B94              ;
1554 2B94              ;
1555 2B94              ; -------------- Handle special item for system window -----------------------
1556 2B94              ;
1557 2B94 A0 10 00              ldy   #TaskData                See if there was a selection.
1558 2B97 B7 1C                 lda   [<InputTaskRecPtr],y
1559 2B99 C9 FF 00              cmp   #255                     Close command?
1560 2B9C D0 10                 bne   edit_item
1561 2B9E              ;
1562 2B9E              ;
1563 2B9E              ; ----------------- Close item select with system window on top --------------
1564 2B9E              ;
1565 2B9E 20 33 2C              jsr   PushFrontWindow
1566 2BA1 A2 05 1C 22           _CloseNDAbyWinPtr              Close desk accessory window.
1567 2BA8              ;
1568 2BA8 A9 1D 00              lda   #wClosedNDA              Tell user that desk accessory was closed.
1569 2BAB 82 6F 00              brl   unliteMenu
1570 2BAE              ;
1571 2BAE              ;
1572 2BAE              ; ----------------- Edit item selected with system window on top -------------
1573 2BAE              ;
1574 2BAE 48           edit_item pha                           Space for result.
1575 2BAF 38                    sec   
1576 2BB0 E9 F9 00              sbc   #249                     Proper command edit command.
1577 2BB3 48                    pha   
1578 2BB4 A2 05 18 22           _SystemEdit 
1579 2BBB A9 1E 00              lda   #wCalledSysEdit          Action, just in case.
1580 2BBE FA                    plx   
1581 2BBF D0 5C                 bne   unliteMenu               Did Desk Manager handle it?
1582 2BC1
1583 2BC1              ;
1584 2BC1 A2 19 00     skip4    ldx   #wInSpecial              Special menu item.
1585 2BC4 60                    rts   
1586 2BC5
1587 2BC5
1588 2BC5              ;---------------------------------------------------------------
1589 2BC5              ;
1590 2BC5              ; See if the controls want to know about menu selections
1591 2BC5              ;
1592 2BC5 A0 16 00     doCtrlMenu ldy    #NewTaskRecord.TaskMask+2
1593 2BC8 B7 1C                 lda    [InputTaskRecPtr],y
1594 2BCA 29 04 00              and    #tmControlMenu
1595 2BCD F0 2C                 beq    @exit2
1596 2BCF
1597 2BCF DA                    phx                            ;save the correct menu event to return
1598 2BD0 A7 1C                 lda    [<InputTaskRecPtr]      ;save the event.what field
1599 2BD2 48                    pha   
1600 2BD3 8A                    txa                            ;pass the correct menu event to the
1601 2BD4 87 1C                 sta    [<InputTaskRecPtr]      ;..control
1602 2BD6 48 F4 FF              PushWordSpace                  ;space for result
1603 2BD9 FF F4 00              PushWord #True                 ;only send menu events to the active ctrl
1604 2BDC 00 F4 00 00           PushLong #0                    ;use the front window
1605 2BE2 D4 1C                 pei   InputTaskRecPtr+2
1606 2BE4                       pei   InputTaskRecPtr
1607 2BE4 A2 10 29 22           _SendEventToCtl 
1608 2BEB 68                    pla   
1609 2BEC F0 09                 beq    @exit1
1610 2BEE 68                    pla                            ;restore the event.what field
1611 2BEF 87 1C                 sta    [<InputTaskRecPtr]
1612 2BF1 68                    pla                            ;cleanup the stack
1613 2BF2 A9 22 00              lda    #wInControlMenu
1614 2BF5 80 26                 bra    unliteMenu
1615 2BF7
1616 2BF7 68           @exit1   pla                            ;restore the event.what field
1617 2BF8 87 1C                 sta    [<InputTaskRecPtr]
1618 2BFA FA                    plx                            ;get back the correct menu event
1619 2BFB 60           @exit2   rts   
1620 2BFC
1621 2BFC
1622 2BFC A2 19 00     doCtrlSpecial ldx    #wInSpecial        ;use the wInSpecial event
1623 2BFF 80 C4                 bra    doCtrlMenu
1624 2C01
1625 2C01
1626 2C01
1627 2C01              ;
1628 2C01              ; --- Desk accessory menu item ---------------------------
1629 2C01              ;
1630 2C01              desk_item  
1631 2C01 A2 1A 00              ldx   #wInDeskItem             Desk accessory event, just in case.
1632 2C04              ;
1633 2C04 A5 05                 lda   <TheTaskMask             Ok to handle desk accessory event?
1634 2C06 29 10 00              and   #TM_OPENNDA
1635 2C09 F0 27                 beq   exit2                    Let application handle desk accessory.
1636 2C0B              ;
1637 2C0B 48                    pha                            Space for result.
1638 2C0C A0 10 00              ldy   #TaskData
1639 2C0F B7 1C                 lda   [<InputTaskRecPtr],y
1640 2C11 48                    pha                            Pass item ID number.
1641 2C12 A2 05 15 22           _OpenNDA                       Open desk accessory.
1642 2C19 68                    pla                            Throw away returned ref value.
1643 2C1A              ;
1644 2C1A A9 1A 00              lda   #wInDeskItem             Tell application that a desk accessory
1645 2C1D              ;                                       was opened.
1646 2C1D
1647 2C1D              unliteMenu  
1648 2C1D 85 03                 sta   <ThisAction
1649 2C1F
1650 2C1F              ;
1651 2C1F F4 00 00              pea   0                        Unhighlight.
1652 2C22 A0 12 00              ldy   #TaskData+2
1653 2C25 B7 1C                 lda   [<InputTaskRecPtr],y     Pass selected menu's ID,
1654 2C27 48                    pha                            to HiliteMenu.
1655 2C28 A2 0F 2C 22           _HiliteMenu 
1656 2C2F              ;
1657 2C2F A2 00 00              ldx   #Null                    Menu selection was handled.
1658 2C32 60           exit2    rts                            x = task return code.
1659 2C33
1660 2C33
1661 2C33
1662 2C33                       ENDP 
1663 2C33
1664 2C33
1665 2C33                       title 'PushFrontWindow' 
1666 2C33              ****************************************************************
1667 2C33              *
1668 2C33              PushFrontWindow PROC 
1669 2C33              *
1670 2C33              * Returns the pointer to the window's grafPort.
1671 2C33              *
1672 2C33              *
1673 2C33              * Inputs:
1674 2C33              *                   none
1675 2C33              *
1676 2C33              * Outputs:
1677 2C33              *                   window's grafPort ptr on stack
1678 2C33              *
1679 2C33              * External Refs:
1680 2C33              *                   none
1681 2C33              *
1682 2C33              * Entry Points:
1683 2C33              *                   none
1684 2C33              *
1685 2C33                       longa on                       ; mode
1686 2C33                       longi on
1687 2C33              *
1688 2C33              ****************************************************************
1689 2C33
1690 2C33
1691 2C33 FA                    plx   
1692 2C34 48                    pha   
1693 2C35 48                    pha   
1694 2C36 DA                    phx   
1695 2C37
1696 2C37 48                    pha   
1697 2C38 48                    pha   
1698 2C39 A2 0E 15 22           _FrontWindow 
1699 2C40 68                    pla   
1700 2C41 FA                    plx   
1701 2C42
1702 2C42 83 03                 sta   3,s
1703 2C44 8A                    txa   
1704 2C45 83 05                 sta   5,s
1705 2C47
1706 2C47 60                    rts   
1707 2C48
1708 2C48                       ENDP 
1709 2C48
1710 2C48
1711 2C48
1712 2C48
1713 2C48                       title 'ckActivate' 
1714 2C48              ****************************************************************
1715 2C48              *
1716 2C48              ckactivate PROC 
1717 2C48              *
1718 2C48              * Check to handle activate/inactivate events.
1719 2C48              *
1720 2C48              * WindPtr is trashed.
1721 2C48              *
1722 2C48              *
1723 2C48              * Inputs:
1724 2C48              *                   TheTaskMask
1725 2C48              *                   InputTaskRecPtr
1726 2C48              *
1727 2C48              * Outputs:
1728 2C48              *                   none
1729 2C48              *
1730 2C48              * External Refs:
1731 2C48                       import MakeGPIntoWP 
1732 2C48              *
1733 2C48              * Entry Points:
1734 2C48              *                   none
1735 2C48              *
1736 2C48                       longa on                       ; mode
1737 2C48                       longi on
1738 2C48              *
1739 2C48              * Change History
1740 2C48              *
1741 2C48              * 01 Dec 88         Steven Glass
1742 2C48              *
1743 2C48              * If the window is active and the control tie bit is clear, 
1744 2C48              * then we invalidate the controls (we used to draw the controls).
1745 2C48              * Drawing the controls made them draw twice (once for activate
1746 2C48              * and once for the update).  Now the only draw during the update.
1747 2C48              *
1748 2C48              ****************************************************************
1749 2C48
1750 2C48              ;
1751 2C48              ;
1752 2C48 A5 05                 lda   <TheTaskMask             Check if it's ok to try and handle
1753 2C4A 29 00 20              and   #TM_CREDRAW              the event.
1754 2C4D F0 24                 beq   exit                     If not, just exit.
1755 2C4F              ;
1756 2C4F 20 74 2C              jsr   MakeGPIntoWP             turn TaskData into a pointer to wind record
1757 2C52              ;
1758 2C52 A0 D2 00              ldy   #wframe                  Check if controls are tied to window's
1759 2C55 B7 09                 lda   [<WindPtr],y             activate state.
1760 2C57 29 08 00              and   #F_CTL_TIE
1761 2C5A D0 17                 bne   exit                     If not, just exit.
1762 2C5C              ;
1763 2C5C 20 D2 2A              jsr   breakout                 Get window port pointer.
1764 2C5F              ;
1765 2C5F A0 0E 00              ldy   #NewTaskRecord.TaskModifiers
1766 2C62 B7 1C                 lda   [<InputTaskRecPtr],y
1767 2C64 29 01 00              and   #$0001                   ; only care about low bit
1768 2C67 48                    pha   
1769 2C68 D4 0B                 pei   WindPtr+2
1770 2C6A D4 09                 pei   WindPtr
1771 2C6C              ;        _FutzCtls
1772 2C6C A2 10 36              ldx   #$3610
1773 2C6F 22 00 00 E1           jsl   $E10000
1774 2C73
1775 2C73 60           exit     rts   
1776 2C74
1777 2C74
1778 2C74                       ENDP 
1779 2C74
1780 2C74                       title 'MakeGPIntoWP' 
1781 2C74              ****************************************************************
1782 2C74              *
1783 2C74              MakeGPIntoWP PROC 
1784 2C74              *
1785 2C74              * This routine takes the window's grafPort pointer in
1786 2C74              * taskData and turns it into a window record pointer
1787 2C74              * putting the result in WindPtr
1788 2C74              *
1789 2C74              *
1790 2C74              * Inputs:
1791 2C74              *                   none
1792 2C74              *
1793 2C74              * Outputs:
1794 2C74              *                   WindPtr
1795 2C74              *
1796 2C74              * External Refs:
1797 2C74              *                   none
1798 2C74              *
1799 2C74              * Entry Points:
1800 2C74              *                   none
1801 2C74              *
1802 2C74                       longa on                       ; mode
1803 2C74                       longi on
1804 2C74              *
1805 2C74              ****************************************************************
1806 2C74
1807 2C74
1808 2C74
1809 2C74 64 09                 stz   <WindPtr
1810 2C76 64 0B                 stz   <WindPtr+2
1811 2C78
1812 2C78 A0 12 00              ldy   #TaskData+2              Break out pointer to window effected.
1813 2C7B B7 1C                 lda   [<InputTaskRecPtr],y
1814 2C7D 88                    dey   
1815 2C7E 88                    dey   
1816 2C7F AA                    tax   
1817 2C80 F0 0D                 beq   IsZero
1818 2C82
1819 2C82 B7 1C                 lda   [<InputTaskRecPtr],y
1820 2C84 38                    sec   
1821 2C85 E9 04 00              sbc   #wport
1822 2C88 85 09                 sta   <WindPtr
1823 2C8A B0 01                 bcs   NoBorrow
1824 2C8C CA                    dex   
1825 2C8D 86 0B        NoBorrow stx   <WindPtr+2
1826 2C8F
1827 2C8F 60           IsZero   rts   
1828 2C90
1829 2C90                       ENDP 
1830 2C90
1831 2C90
1832 2C90
1833 2C90                       title 'InvertIfNecessary' 
1834 2C90              ****************************************************************
1835 2C90              *
1836 2C90              InvertIfNecessary PROC 
1837 2C90              *
1838 2C90              * This routine takes a control handle as input in a & x and
1839 2C90              * checks to see if the control is a checkbox or radio button
1840 2C90              * control.  If it is such a control, we change the
1841 2C90              * control value.
1842 2C90              *
1843 2C90              *
1844 2C90              * Inputs:
1845 2C90              *                   a & x = control handle
1846 2C90              *
1847 2C90              * Outputs:
1848 2C90              *                   none
1849 2C90              *
1850 2C90              * External Refs:
1851 2C90              *                   none
1852 2C90              *
1853 2C90              * Entry Points:
1854 2C90              *                   none
1855 2C90              *
1856 2C90                       longa on                       ; mode
1857 2C90                       longi on
1858 2C90              *
1859 2C90              * Change History
1860 2C90              *
1861 2C90              * 19 Feb 89         STeven Glass
1862 2C90              *
1863 2C90              * This used to be in line code inside Taskmaster Content.
1864 2C90              * It is now a subroutine so that it can be called from
1865 2C90              * inside TaskMasterKey.
1866 2C90              *
1867 2C90              ****************************************************************
1868 2C90
1869 2C90                             DefineStack  
1870 2C90              CallersD       word  
1871 2C90              TempA          long  
1872 2C90              TempB          long  
1873 2C90              RTS            word  
1874 2C90
1875 2C90
1876 2C90 DA                    phx   
1877 2C91 48                    pha   
1878 2C92 DA                    phx   
1879 2C93 48                    pha   
1880 2C94 0B                    phd   
1881 2C95 3B                    tsc   
1882 2C96 5B                    tcd   
1883 2C97
1884 2C97
1885 2C97
1886 2C97 A7 03                 lda   [TempA]                  deref handle
1887 2C99 AA                    tax   
1888 2C9A A0 02 00              ldy   #2
1889 2C9D B7 03                 lda   [TempA],y
1890 2C9F 85 09                 sta   TempB+2
1891 2CA1 86 07                 stx   TempB
1892 2CA3
1893 2CA3 A0 14 00              ldy   #NewCtlRecord.ctlProc    Look at the Proc ref
1894 2CA6 B7 07                 lda   [TempB],y
1895 2CA8 D0 33                 bne   NotSpecial               If not zero, its not check or radio
1896 2CAA C8                    iny   
1897 2CAB C8                    iny   
1898 2CAC B7 07                 lda   [TempB],y
1899 2CAE 29 FF 7F              and   #$7FFF
1900 2CB1 C9 00 02              cmp   #^checkControl**$7FFFFFFF Is it check?
1901 2CB4 D0 14                 bne   NotCheck
1902 2CB6
1903 2CB6 48                    pha                            Get Current Check value
1904 2CB7 D4 05                 pei   TempA+2
1905 2CB9 D4 03                 pei   TempA
1906 2CBB A2 10 1A 22           _GetCtlValue 
1907 2CC2 68                    pla   
1908 2CC3 F0 0A                 beq   SetValueTo1
1909 2CC5
1910 2CC5 F4 00 00              PushWord #0 
1911 2CC8 80 08                 bra   SetTheValue
1912 2CCA
1913 2CCA
1914 2CCA C9 00 04     NotCheck cmp   #^radioControl**$7FFFFFFF Is it radio
1915 2CCD D0 0E                 bne   NotSpecial
1916 2CCF
1917 2CCF
1918 2CCF F4 01 00     SetValueTo1 PushWord #1 
1919 2CD2 D4 05        SetTheValue pei   TempA+2
1920 2CD4 D4 03                 pei   TempA
1921 2CD6 A2 10 19 22           _SetCtlValue 
1922 2CDD
1923 2CDD 2B           NotSpecial pld   
1924 2CDE 68                    pla   
1925 2CDF 68                    pla   
1926 2CE0 68                    pla   
1927 2CE1 68                    pla   
1928 2CE2
1929 2CE2 60                    rts   
1930 2CE3
1931 2CE3                       ENDP 
1932 2CE3
1933 2CE3
1934 2CE3
1935 2CE3
1936 2CE3
1937 2CE3
1938 2CE3
1939 2CE3
1940 2CE3                       title 'ckDoubleClick' 
1941 2CE3              ****************************************************************
1942 2CE3              *
1943 2CE3              ckDoubleClick PROC EXPORT 
1944 2CE3              *
1945 2CE3              * Set the appropriate double click fields in the taskrecord.
1946 2CE3              *
1947 2CE3              *
1948 2CE3              *   IN:             x/a = pointer to task record.
1949 2CE3              *                   Called only when there has been a button down.
1950 2CE3              *                   ClickCount field must be set to zero by 
1951 2CE3              *                       application first time record is used.
1952 2CE3              *
1953 2CE3              *  Out:             All registers trashed.
1954 2CE3              *
1955 2CE3              * External Refs:
1956 2CE3              *                   none
1957 2CE3              *
1958 2CE3              * Entry Points:
1959 2CE3              *                   none
1960 2CE3              *
1961 2CE3                       longa on                       ; mode
1962 2CE3                       longi on
1963 2CE3              *
1964 2CE3              ****************************************************************
1965 2CE3
1966 2CE3              ;
1967 2CE3              @saveDpage equ   1
1968 2CE3              @taskRec equ   @saveDpage+2
1969 2CE3              ;
1970 2CE3              ;
1971 2CE3 DA                    phx                            Save pointer to task record.
1972 2CE4 48                    pha   
1973 2CE5              ;
1974 2CE5 0B                    phd                            Save caller's direct page pointer.
1975 2CE6 3B                    tsc                            Switch direct page into stack.
1976 2CE7 5B                    tcd   
1977 2CE8              ;
1978 2CE8              ;
1979 2CE8              ; --- Check if caller wants double-clicks checked.
1980 2CE8              ;
1981 2CE8 A0 16 00              ldy   #taskMask+2
1982 2CEB B7 03                 lda   [<@taskRec],y
1983 2CED 29 08 00              and   #tmMultiClick
1984 2CF0 F0 7A                 beq   @exit
1985 2CF2              ;
1986 2CF2 A0 1C 00              ldy   #clickCount              Is this the first time through?
1987 2CF5 B7 03                 lda   [<@taskRec],y
1988 2CF7 F0 59                 beq   @singleClick             Set first click.
1989 2CF9              ;
1990 2CF9              ;
1991 2CF9              ; --- Check for multi click.
1992 2CF9              ;
1993 2CF9 A0 06 00              ldy   #when
1994 2CFC B7 03                 lda   [<@taskRec],y            Time of this click.
1995 2CFE 38                    sec   
1996 2CFF A0 18 00              ldy   #lastClickWhen
1997 2D02 F7 03                 sbc   [<@taskRec],y            less time of last click,
1998 2D04 AA                    tax   
1999 2D05 A0 08 00              ldy   #when+2
2000 2D08 B7 03                 lda   [<@taskRec],y
2001 2D0A A0 1A 00              ldy   #lastClickWhen+2
2002 2D0D F7 03                 sbc   [<@taskRec],y            equals time inbetween.
2003 2D0F D0 41                 bne   @singleClick             Is it a double click?
2004 2D11              ;
2005 2D11 DA                    phx                            Save time between clicks.
2006 2D12 48                    pha                            Space for result.
2007 2D13 48                    pha   
2008 2D14 A2 06 11 22           _GetDblTime 
2009 2D1B 68                    pla   
2010 2D1C FA                    plx   
2011 2D1D C3 01                 cmp   1,s                      Is double-click speed less than the
2012 2D1F 68                    pla                            time between clicks?
2013 2D20 90 30                 bcc   @singleClick             If it is, no multi click, reset to single.
2014 2D22              ;
2015 2D22 A0 2A 00              ldy   #lastClicky              Is position of new click near last?
2016 2D25 B7 03                 lda   [<@taskRec],y
2017 2D27 38                    sec   
2018 2D28 A0 0A 00              ldy   #where+y1
2019 2D2B F7 03                 sbc   [<@taskRec],y
2020 2D2D 18                    clc   
2021 2D2E 69 02 00              adc   #2
2022 2D31 C9 07 00              cmp   #7
2023 2D34 B0 1C                 bcs   @singleClick
2024 2D36              ;
2025 2D36 A0 2C 00              ldy   #lastClickx
2026 2D39 B7 03                 lda   [<@taskRec],y
2027 2D3B 38                    sec   
2028 2D3C A0 0C 00              ldy   #where+x1
2029 2D3F F7 03                 sbc   [<@taskRec],y
2030 2D41 18                    clc   
2031 2D42 69 03 00              adc   #3
2032 2D45 C9 0B 00              cmp   #11
2033 2D48 B0 08                 bcs   @singleClick
2034 2D4A              ;
2035 2D4A A0 1C 00              ldy   #clickCount              Multi click, increment number of clicks.
2036 2D4D B7 03                 lda   [<@taskRec],y
2037 2D4F 1A                    inc   a
2038 2D50 80 06                 bra   @storeClick
2039 2D52              ;
2040 2D52              ;
2041 2D52              ; --- Set information about this click in task record.
2042 2D52              ;
2043 2D52 A9 01 00     @singleClick lda   #1                   Set click number.
2044 2D55 A0 1C 00              ldy   #clickCount
2045 2D58 97 03        @storeClick sta   [<@taskRec],y
2046 2D5A
2047 2D5A A0 06 00              ldy   #when                    Set when.
2048 2D5D A2 1A 00              ldx   #lastClickWhen+2
2049 2D60 20 70 2D              jsr   @moveLong
2050 2D63
2051 2D63 A0 0A 00              ldy   #where                   Set where.
2052 2D66 A2 2C 00              ldx   #lastClicky+2
2053 2D69 20 70 2D              jsr   @moveLong
2054 2D6C              ;
2055 2D6C              ;
2056 2D6C              ; --- Clean up stack and exit.
2057 2D6C              ;
2058 2D6C 2B           @exit    pld                            Restore caller's direct page pointer.
2059 2D6D FA                    plx                            clean up stack (removing pointer pushed at
2060 2D6E FA                    plx                            beginning).
2061 2D6F 60                    rts   
2062 2D70
2063 2D70              ;--------------------------------------------
2064 2D70              ;                   Move a long within task record.
2065 2D70              ;--------------------------------------------
2066 2D70              ;
2067 2D70              ;   IN: y = source index.
2068 2D70              ;       x = destination index + 2.
2069 2D70              ;
2070 2D70 B7 03        @moveLong lda   [<@taskRec],y
2071 2D72 48                    pha   
2072 2D73 C8                    iny   
2073 2D74 C8                    iny   
2074 2D75 B7 03                 lda   [<@taskRec],y
2075 2D77 9B                    txy   
2076 2D78 97 03                 sta   [<@taskRec],y
2077 2D7A 88                    dey   
2078 2D7B 88                    dey   
2079 2D7C 68                    pla   
2080 2D7D 97 03                 sta   [<@taskRec],y
2081 2D7F 60                    rts   
2082 2D80
2083 2D80                       ENDP 
2084 2D80
2085 2D80                       END   
